/*-------------------------------------------------------------------------
 integer to string conversion
 Written by:   Bela Torok, 1999
               bela.torok@kssg.ch
 usage:
 uitoa(unsigned int value, char* string, int radix)
 itoa(int value, char* string, int radix)
 value  ->  Number to be converted
 string ->  Result
 radix  ->  Base of value (e.g.: 2 for binary, 10 for decimal, 16 for hex)
---------------------------------------------------------------------------*/

#define NUMBER_OF_DIGITS 6   /* space for NUMBER_OF_DIGITS + '\0' */
#define RADIX 10

void uitoa(unsigned int value, char* string)
{
unsigned char index, i;

  index = NUMBER_OF_DIGITS;
  i = 0;

  do {
    string[--index] = '0' + (value % RADIX);
    if ( string[index] > '9') string[index] += 'A' - ':';   /* continue with A, B,.. */
    value /= RADIX;
  } while (value != 0);

  do {
    string[i++] = string[index++];
  } while ( index < NUMBER_OF_DIGITS );

  string[i] = 0; /* string terminator */
}
